<?php

namespace Forums\Data;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('conversation_id', 'user_id', 'content');

    public function conversation()
    {
        return $this->belongsTo('Conversation');
    }

    public function author()
    {
        return $this->belongsTo('User');
    }

}